<!---
Name:        WDDXFunctions.cfm
Author:      Nate Weiss and Ben Forta
Description: A general-purpose UDF library to make using WDDX easier
Created:     02/01/05
--->


<!---
Function to write any value to the
server's drive as a WDDX packet.
--->
<cffunction name="WDDXFileWrite"
            returntype="void">
  <!--- Required arguments --->
  <cfargument name="File"
              type="string"
              required="Yes">
  <cfargument name="Value"
              type="any" 
              required="Yes">

  <!--- This variable is for this function's use only --->
  <cfset var WddxPacket="">
  
  <!--- Convert the value to a WDDX packet --->
  <cfwddx action="CFML2WDDX"
          input="#ARGUMENTS.Value#"
          output="WddxPacket">
  
  <!--- Save the WDDX packet to the server's drive --->
  <cffile action="WRITE"
          file="#ARGUMENTS.File#"
          output="#WddxPacket#">
 
</cffunction>


<!---
Function to read a value from a WDDX packet on
the server's drive. Returns the value in the packet,
after deserialization.
--->
<cffunction name="WDDXFileRead"
            returntype="any">
  <!--- Required argument --->
  <cfargument name="File"
              type="string"
              required="Yes">

  <!--- These variables are for this function's use only --->
  <cfset var Result="">
  <cfset var WddxPacket="">
  
  <!--- Read the WDDX packet from the server's drive --->
  <cffile action="READ"
          file="#ARGUMENTS.File#"
          variable="WddxPacket">
    
  <!--- Deserialize the value in the WDDX packet --->  
  <cfwddx action="WDDX2CFML"
          input="#WddxPacket#"
          output="Result">
    
  <!--- Return the result --->  
  <cfreturn Result>  
</cffunction>


<!---
Function to read a value from a WDDX packet
on a Web server. Returns the value in the
packet, after deserialization.
--->
<cffunction name="WDDXHttpGet"
            returntype="any">
  <!--- Required argument --->
  <cfargument name="URL"
              type="string"
              required="Yes">

  <!--- The Result variable is for this function's use only --->
  <cfset var Result="">
  
  <!--- Fetch the WDDX packet over the wire --->
  <cfhttp method="GET"
          url="#ARGUMENTS.URL#">
    
  <!--- Deserialize the value in the WDDX packet --->  
  <cfwddx action="WDDX2CFML"
          input="#CFHTTP.FileContent#"
          output="Result">
    
  <!--- Return the result --->  
  <cfreturn Result>  
</cffunction>



<!---
Function to write any value to a client variable
as a WDDX packet.
--->
<cffunction name="WDDXClientWrite"
            returntype="void">
  <!--- Required arguments --->
  <cfargument name="Name"
              type="string"
              required="Yes">
  <cfargument name="Value"
              type="any"
              required="Yes">

  <!--- This variable is for this function's use only --->
  <cfset var WddxPacket="">
  
  <!--- Convert the value to a WDDX packet --->
  <cfwddx action="CFML2WDDX"
          input="#ARGUMENTS.Value#"
          output="WddxPacket">

  <!--- Save the packet as a CLIENT variable --->  
  <cfset CLIENT[ARGUMENTS.Name]=WddxPacket>
</cffunction>


<!---
Function to retrieve a value stored with
WDDXClientWrite().
--->
<cffunction name="WDDXClientRead"
            returntype="any">
  <!--- Required argument --->
  <cfargument name="Name"
              type="string"
              required="Yes">

  <!--- These variables are for this function's use only --->
  <cfset var Result="">
  <cfset var WddxPacket="">

  <!--- If the client variable exists and is valid --->  
  <cfif IsDefined("CLIENT.#ARGUMENTS.Name#")>
    <cfif IsWddx(CLIENT[ARGUMENTS.Name])>
      <!--- Deserialize the value in the WDDX packet --->  
      <cfwddx action="WDDX2CFML"
              input="#CLIENT[ARGUMENTS.Name]#"
              output="Result">
    
    </cfif>
  </cfif>
    
  <!--- Return the result --->  
  <cfreturn Result>  
</cffunction>
