<!---
Name:        UseFilmsRobot2c.cfm
Author:      Nate Weiss and Ben Forta
Description: Fetches a WDDX packet via
             HTTP and uses the query
             contained within
Created:     02/01/05
--->


<!--- We need a film ID to be supplied in the URL --->
<cfparam name="URL.FilmID"
         type="numeric">

<!---
Flag used to indicate whether browser is requesting the the film's
image to display on the detail page, or the detail page itself.
--->
<cfparam name="URL.ImageOnly"
         type="boolean"
         default="No">

<!--- Location of the robot page --->
<!--- The URL could be anywhere in world, not just on this server --->
<cfset RobotURL="http://localhost:8500/ows_adv/16/FilmsRobot2.cfm">

<!--- Add parameters so the robot knows to return detailed information --->
<cfif URL.ImageOnly>
  <cfset RobotURL=RobotURL&"?FilmID=#URL.FilmID#&Details=No&Images=Yes">
<cfelse>
  <cfset RobotURL=RobotURL&"?FilmID=#URL.FilmID#&Details=Yes&Images=No">
</cfif>

<!--- Contact the robot page and retrieve the WDDX packet it returns --->
<cfhttp method="Get"
        url="#RobotURL#">

<!--- Deserialize the packet, which we know holds a query recordset --->  
<cfwddx action="WDDX2CFML"
        input="#CFHTTP.FileContent#"
        output="FilmQuery">

<!---
If the ImageOnly flag is set, send back the binary image itself
--->
<cfif URL.ImageOnly>
  <!---
  If there is binary image content for this film
  --->  
  <cfif IsBinary(FilmQuery.ImageContent)>
    <!--- Temporary location for the image --->
    <cfset TempFile=GetTempFile(GetTempDirectory(), "img")>
    
    <!--- Save the image content from the WDDX packet to the temp file --->
    <cffile action="WRITE"
            file="#TempFile#"
            output="#FilmQuery.ImageContent#">

    <!---
    Stream the content to the browser.
    The temporary file will be deleted when finished.
    --->
    <cfcontent type="image/gif"
               reset="Yes"
               file="#TempFile#"
               deletefile="Yes">

  <!--- If we are meant to send back image, but robot didn't provide it --->
  <cfelse>
    <!--- Log the problem --->
    <cflog text="The image for FilmID #URL.FilmID# was not recieved."
           file="FilmsRobot"
           type="Information">
          
  </cfif>


<!---
When the page is called without the ImageOnly flag,
we should create the detail page for the film (as HTML).
--->
<cfelse>
  <!---
  We can now use the query object normally,
  just as if it came directly from a <cfquery> tag.
  --->
  <cfoutput query="FilmQuery">
    <h2>#MovieTitle#</h2>
    #PitchText#

    <p><strong>Summary:</strong><br>
    #Summary#<br>

    <p><strong>Budget:</strong><br>
    #LSCurrencyFormat(AmountBudgeted)#<br>

    <p><strong>Date In Theaters:</strong><br>
    #LSDateFormat(DateInTheaters)#<br>
  
    <!--- If there is an image available --->  
    <cfif ImageName NEQ "">
      <p><strong>Image:</strong><br>
      
      <!---
      The SRC for image is this page's URL with ImageOnly flag added.
      The browser will call this page again to get the image itself.
      --->
      <img src="UseFilmsRobot2c.cfm?FilmID=#URL.FilmID#&ImageOnly=Yes"
           border="0">
    </cfif>
  </cfoutput>     
</cfif>
