<!---
Name:        UseFilmsRobot2b.cfm
Author:      Nate Weiss and Ben Forta
Description: Fetches a WDDX packet via
             HTTP and uses the query
             contained within
Created:     02/01/05
--->


<!--- We need an ID number for the desired film --->
<cfparam name="URL.FilmID"
         type="numeric">

<!--- Location of the robot page --->
<!--- The URL could be anywhere in world, not just on this server --->
<cfset RobotURL="http://localhost:8500/ows_adv/16/FilmsRobot2.cfm">

<!--- Add parameters so the robot knows to return detailed information --->
<cfset RobotURL=RobotURL&"?FilmID=#URL.FilmID#&Details=Yes&Images=Yes">

<!--- Contact the robot page and retrieve the WDDX packet it returns --->
<cfhttp method="Get"
        url="#RobotURL#">

<!--- Deserialize the packet, which we know holds a query recordset --->  
<cfwddx action="WDDX2CFML"
        input="#CFHTTP.FileContent#"
        output="FilmQuery">

<!--- If there is binary image content for this film --->  
<cfif IsBinary(FilmQuery.ImageContent)>
  <!--- Folder location for storing deserialized images --->
  <cfset DeserializedImageFolder=ExpandPath("DeserializedImages")>

  <!--- Create the folder if it doesn't already exist --->
  <cfif NOT DirectoryExists(DeserializedImageFolder)>
    <cfdirectory action="Create"
                 directory="#DeserializedImageFolder#">
  </cfif>
  
  <!--- The image will be saved using the name in the ImageName column --->
  <cfset ImageFilePath=DeserializedImageFolder & "/" & FilmQuery.ImageName>

  <!--- Save image to DeserializedImages folder on the server's drive --->
  <cffile action="WRITE"
          file="#ImageFilePath#"
          output="#FilmQuery.ImageContent#">
</cfif>
  
<!---
We can now use the query object normally,
just as if it came directly from a <cfquery> tag.
--->
<cfoutput query="FilmQuery">
  <h2>#MovieTitle#</h2>
  #PitchText#
 
  <p><strong>Summary:</strong><br>
  #Summary#<br>
 
  <p><strong>Budget:</strong><br>
  #LSCurrencyFormat(AmountBudgeted)#<br>

  <p><strong>Date In Theaters:</strong><br>
  #LSDateFormat(DateInTheaters)#<br>

  <!--- If there is an image available --->  
  <cfif ImageName NEQ "">
    <p><strong>Image:</strong><br>
    <img src="DeserializedImages/#ImageName#" border="0">
  </cfif>
</cfoutput>
