<!---
Name:        UseFilmsRobot1b.cfm
Author:      Nate Weiss and Ben Forta
Description: Fetches a WDDX packet via
             HTTP and uses the query
             contained within
Created:     02/01/05
--->

<!--- We need a FilmID --->
<cfparam name="URL.FilmID"
         type="numeric">

<!--- Location of the robot page --->
<!--- The URL could be anywhere in world, not just on this server --->
<cfset RobotURL="http://localhost:8500/ows_adv/16/FilmsRobot1.cfm">

<!--- Add parameters so the robot knows to return detailed information --->
<cfset RobotURL=RobotURL & "?FilmID=#URL.FilmID#&Details=Yes">

<!--- Contact the robot page and retrieve the WDDX packet it returns --->
<cfhttp method="Get"
        url="#RobotURL#">

<!--- Deserialize the packet, which we know holds a query recordset --->  
<cfwddx action="WDDX2CFML"
        input="#CFHTTP.FileContent#"
        output="FilmQuery">
  
<!---
We can now use the query object normally,
just as if it came directly from a <cfquery> tag
--->
<cfoutput query="FilmQuery">
  <h2>#MovieTitle#</h2>
  #PitchText#
 
  <p><strong>Summary:</strong><br>
  #Summary#<br>
 
  <p><strong>Budget:</strong><br>
  #LSCurrencyFormat(AmountBudgeted)#<br>

  <p><strong>Date In Theaters:</strong><br>
  #LSDateFormat(DateInTheaters)#<br>
</cfoutput>
