<!---
Name:        Serialize2.cfm
Author:      Nate Weiss and Ben Forta
Description: Serialize data into a WDDX packet
Created:     02/01/05
--->

<html>

<head>
 <title>WDDX Demonstration</title>
</head>

<body>

<!--- Run a simple database query to include in the WDDX packet --->
<!--- Limit the query to just 5 rows to keep things simple --->
<cfquery name="filmsquery" datasource="ows" maxrows="5">
 SELECT FilmID, MovieTitle, AmountBudgeted, DateInTheaters
 FROM Films
 ORDER BY MovieTitle
</cfquery>

<!--- Create a structure --->
<cfset MyStruct=StructNew()>
<!--- Add a few simple string values --->
<cfset MyStruct.CompanyName="Orange Whip Studios">
<cfset MyStruct.CompanyURL="http://www.orangewhipstudios.com">
<!--- Add the current date and time --->
<cfset MyStruct.PacketDate=Now()>
<!--- Add the contents of the FilmsQuery query --->
<cfset MyStruct.Films=FilmsQuery>
<!--- Add a simple array --->
<cfset MyStruct.Offices=ArrayNew(1)>
<cfset MyStruct.Offices[1]="New York, NY">
<cfset MyStruct.Offices[2]="Paris, France">
<cfset MyStruct.Offices[3]="Pittsfield, MA">

<!--- Serialize the #MyStruct# structure into a WDDX Packet --->
<cfwddx action="CFML2WDDX"
        input="#MyStruct#"
        output="MyWDDXPacket">

<!--- Output WDDX packet so we can see what it looks like --->
<!--- (HTMLEditFormat function lets us see tags properly) --->
<cfoutput>
 <p><strong>The structure was serialized into the following WDDX packet:</strong></p>

 #HTMLEditFormat(MyWDDXPacket)#
</cfoutput>

<!--- Save the WDDX packet to a file on the server's drive --->
<cffile action="WRITE"
        file="#ExpandPath('StructPacket.txt')#"
        output="#MyWDDXPacket#">

</body>
</html>
