<!---
Name:        Serialize1.cfm
Author:      Nate Weiss and Ben Forta
Description: Serialize data into a WDDX packet
Created:     02/01/05
--->

<html>

<head>
 <title>WDDX Demonstration</title>
</head>

<body>

<!--- set the #message# variable to a simple string value --->
<cfset Message="Hello, World!">

<!--- Serialize the #Message# variable into a WDDX Packet --->
<cfwddx action="CFML2WDDX"
        input="#Message#"
        output="MyWDDXPacket">

<!--- Output WDDX packet so we can see what it looks like --->
<!--- (HTMLEditFormat function lets us see tags properly) --->
<cfoutput>
 <p><strong>Original Message:</strong> #Message#</p>
 <p><strong>The message was serialized into the following WDDX packet:</strong></p>

 #HTMLEditFormat(MyWDDXPacket)#
</cfoutput>

<!--- Save the WDDX packet to a file on the server's drive --->
<cffile action="WRITE"
        file="#ExpandPath('StringPacket.txt')#"
        output="#MyWDDXPacket#">

</body>
</html>
