<!---
Name:        FilmsRobot2.cfm
Author:      Nate Weiss and Ben Forta
Description: Creates a back-end web page that
             supplies data about films
Created:     02/01/05
--->

<!---
If a WDDX packet is supplied to this page as a FORM or URL parameter
--->
<cfif IsDefined("ParamsAsWDDX")>
  <!---
  Deserialize the packet and use its contents as parameters
  to control this page's behavior
  --->
  <cfwddx action="WDDX2CFML"
          input="#ParamsAsWDDX#"
          output="IncomingParams">
<cfelse>
  <!---
  The values in this structure will be used to control page's behavior
  --->
  <cfset IncomingParams=StructNew()>
</cfif>

<!---
If form parameters are being submitted, use them to contol behavior
--->
<cfif StructCount(FORM) GT 1>
  <cfset StructAppend(IncomingParams, FORM, "Yes")>
  <cfset StructDelete(IncomingParams, "FIELDNAMES")>
<!--- Otherwise, just use  --->
<cfelse>
  <cfset StructAppend(IncomingParams, URL, "Yes")>
</cfif>


<!---
The incoming WDDX packet may include these parameters.
The default values are used when there is no incoming packet,
or when the incoming packet doesn't include the parameter.
--->
<cfparam name="IncomingParams.usecache" type="boolean" default="yes">
<cfparam name="IncomingParams.details" type="boolean" default="no">
<cfparam name="IncomingParams.filmid" type="numeric" default="0">
<cfparam name="IncomingParams.keywords" type="string" default="">
<cfparam name="IncomingParams.orderby" type="string" default="movietitle">
<cfparam name="IncomingParams.images" type="boolean" default="no">

<!--- If a cached query may be used --->
<cfif IncomingParams.UseCache>
  <cfset CachedWithin=CreateTimeSpan(0,0,30,0)>
<cfelse>  
  <cfset CachedWithin=CreateTimeSpan(0,0,0,0)>
</cfif>

<!---
Execute a database query to select film information from database
--->
<cfquery name="FilmsQuery" 
         datasource="ows" 
         cachedwithin="#CachedWithin#">
  SELECT
    <!--- If all information about film(s) is desired --->
    <cfif IncomingParams.Details>
      *
    <!--- Otherwise, return the film's ID and title --->  
    <cfelse>
      FilmID, MovieTitle 
      <cfif IncomingParams.Images>, ImageName</cfif>
    </cfif>
  FROM Films
  <!--- If a specific film ID was specified --->
  <cfif IncomingParams.FilmID GT 0>
    WHERE FilmID = #IncomingParams.FilmID#
  <!--- If keywords were provided to search with --->  
  <cfelseif IncomingParams.Keywords NEQ "">  
    WHERE MovieTitle LIKE '%#IncomingParams.Keywords#%'
  </cfif>
  <!--- Order the results appropriately --->
  ORDER BY #IncomingParams.OrderBy#
</cfquery>

<!--- If the requesting process wants images included in the packet... --->
<cfif IncomingParams.Images>
  <!--- Add an ImageContent column to the query recordset --->
  <cfset QueryAddColumn(FilmsQuery, "ImageContent", ArrayNew(1))>
  
  <!--- For each row in the recordset --->
  <cfloop query="FilmsQuery">
    <!--- If this film has an associated image (according to the database) --->
    <cfif ImageName NEQ "">
      <!--- Location of the image on the server's drive --->
      <cfset ImagePath=ExpandPath("/ows/images/#ImageName#")>
      
      <!--- If the file actually exists on the server --->
      <cfif FileExists(ImagePath)>
        <!--- Read the contents of the file --->
        <!--- ImageBinary will be a binary object variable --->
        <cffile action="READBINARY"
                file="#ImagePath#"
                variable="ImageBinary">
        
        <!--- Store the binary object variable in the ImageContent column --->  
        <cfset FilmsQuery.ImageContent[CurrentRow] = ImageBinary>  
      </cfif>
      
    </cfif>
  </cfloop>
</cfif>

<!--- Convert the query recordset to a WDDX packet --->
<cfwddx action="CFML2WDDX"
        input="#FilmsQuery#"
        output="WDDXPacket">
  
<!---
Return the packet to whatever system requested this page.
Use <cfcontent> to reset the output stream, so that any whitespace,
page headers, etc., included by Application.cfm gets discarded.
--->
<cfcontent type="text/xml" 
           reset="Yes"><cfoutput>#WDDXPacket#</cfoutput>
		   