<!---
Name:        FilmsRobot1.cfm
Author:      Nate Weiss and Ben Forta
Description: Creates a back-end web page that
             supplies data about films
Created:     02/01/05
--->

<!--- URL Parameters to control what film data the page responds with --->
<cfparam name="URL.FilmID"
         type="numeric"
         default="0">
<cfparam name="URL.Details"
         type="boolean"
         default="No">
<cfparam name="URL.Keywords"
         type="string"
         default="">

<!--- Execute a database query to select film information from database --->
<cfquery name="FilmsQuery" 
         datasource="ows">

  SELECT
    <!--- If all information about film(s) is desired --->
    <cfif URL.Details>
      *
    <!--- Otherwise, return the film's ID and title --->  
    <cfelse>
      FilmID, MovieTitle 
    </cfif>
  FROM Films
  <!--- If a specific film ID was specified --->
  <cfif URL.FilmID GT 0>
    WHERE FilmID = #URL.FilmID#
  <!--- If keywords were provided to search with --->  
  <cfelseif URL.Keywords NEQ "">  
    WHERE MovieTitle LIKE '%#URL.Keywords#%'
       OR Summary LIKE '%#URL.Keywords#%'
  </cfif>
  ORDER BY MovieTitle
</cfquery>


<!--- Convert the query recordset to a WDDX packet --->
<cfwddx action="CFML2WDDX"
        input="#FilmsQuery#">
