<!---
Name:        Deserialize2.cfm
Author:      Nate Weiss and Ben Forta
Description: Deserialize data from a WDDX packet
Created:     02/01/05
--->

<html>

<head>
 <title>WDDX Demonstration</title>
</head>

<body>

<!--- Read the WDDX packet from the file on the server's drive --->
<cffile action="READ"
        file="#ExpandPath('StructPacket.txt')#"
        variable="MyWDDXPacket">

<!--- Deserialize the WDDX packet back into native #MyStruct# variable --->
<cfwddx action="WDDX2CFML"
        input="#MyWDDXPacket#"
        output="MyStruct">

<!--- Output various information from the packet, to prove that --->  
<!--- the structure contains all of the original information --->
<cfoutput>
 <!--- MyStruct.CompanyName should be a string value --->
 <strong>Company name:</strong> 
 #MyStruct.CompanyName#<br>
  
 <!--- MyStruct.Offices should be an array --->
 <strong>Number of offices:</strong> 
 #ArrayLen(MyStruct.Offices)#<br>
  
 <!--- MyStruct.PacketDate should be a date/time object --->
 <strong>Information recorded at:</strong> 
 #DateFormat(MyStruct.PacketDate)# #TimeFormat(MyStruct.PacketDate)#<br>

 <!--- MyStruct.Films should be a query recordset --->
 <p><strong>Films:</strong><br>
 <cfloop query="MyStruct.Films">
  #MovieTitle#<br>
 </cfloop>
</cfoutput>

</body>
</html>
