<!---
Name:        Application.cfm
Author:      Nate Weiss and Ben Forta
Description: Executes on every request
Created:     02/01/05
--->

<!--- Define the application --->
<cfapplication name="OrangeWhipIntranet"
               clientmanagement="Yes">

<!--- Include the WDDXFunctions UDF library --->
<cfinclude template="WDDXFunctions.cfm">

<!--- If the application has not been initialized yet, or if the --->
<!--- user is currently trying to change the application's settings... --->
<cfif (NOT IsDefined("APPLICATION.Initialized")) 
  OR IsDefined("FORM.IsSavingSettings")>
  
  <!--- Initialize the application --->
  <cftry>
    <!--- Location of AppSettings.xml file --->
    <cfset SettingsFile = GetDirectoryFromPath(GetCurrentTemplatePath()) 
      & "/AppSettings.xml">  

    <!--- Attempt to initialize application. If this fails for any reason, --->
    <!--- the <cfcatch> block will display the Settings form page. --->
    <cfset APPLICATION.AppSettings = WddxFileRead(SettingsFile)>

    <!--- Remember that the application has been initialized, so that --->
    <!--- this whole section will be skipped until server is restarted --->
    <cfset APPLICATION.Initialized = True>

    <!--- Display the Settings form page if any exceptions are thrown --->    
    <cfcatch type="Any">
      <cfinclude template="AppSettingsForm.cfm">
      <cfabort>
    </cfcatch>
  </cftry>
</cfif>
