<!---
Name:        AppSettingsForm.cfm
Author:      Nate Weiss and Ben Forta
Description: Provides a form for editing this application's settings
Created:     02/01/05
--->

<!--- Location of AppSettings.xml file --->
<cfset ThisFolder=GetDirectoryFromPath(GetCurrentTemplatePath())>
<cfset SettingsFile=ThisFolder & "AppSettings.xml">  

<!--- Read time zone recordset from WDDX packet on the server's drive --->
<cfset TimeZones=WDDXFileRead(ThisFolder & "TimeZoneRecordsetPacket.xml")>
  
<!--- If the form is being submitted --->
<cfif IsDefined("FORM.IsSavingSettings")>
  <!--- Make new structure called Settings, which contains data from form --->
  <cfset Settings.CompanyName=FORM.CompanyName>
  <cfset Settings.AppTitle=FORM.AppTitle>
  <cfset Settings.HTML.PageColor=FORM.PageColor>
  <cfset Settings.HTML.FontFace=FORM.FontFace>
  
  <!--- Use in-memory query to get information about selected time zone --->
  <cfquery dbtype="query" name="SelectedTimeZone">
    SELECT * FROM TimeZones
    WHERE Code='#FORM.TimeZoneCode#'
  </cfquery>
  
  <!--- Add information about the selected time zone --->
  <cfset Settings.TimeZone.Code=SelectedTimeZone.Code>
  <cfset Settings.TimeZone.Offset=SelectedTimeZone.Offset>
  <cfset Settings.TimeZone.Description=SelectedTimeZone.Description>

  <!--- Remember when these edits were made --->
  <cfset Settings.SettingsLastEdited=Now()>

  <!--- Save the settings as a WDDX packet on the server's drive --->
  <cfset WddxFileWrite(SettingsFile, Settings)>
 
  <!--- Clear the application's Initialized flag --->
  <!--- This will cause settings to be re-read on the next page request --->
  <cfset StructDelete(APPLICATION, "Initialized")>
  
  <!--- Reload whatever page was requested --->
  <cflocation url="#CGI.SCRIPT_NAME#?#CGI.QUERY_STRING#">  
</cfif>



<!--- Read the settings from the WDDX Packet on the server's drive --->
<cfset AppSettings=WDDXFileRead(SettingsFile)>

<!--- The application settings should include the following --->
<!--- These default values will be used if the settings file is missing --->
<cfparam name="AppSettings.CompanyName" type="string" default="">
<cfparam name="AppSettings.AppTitle" type="string" default="">
<cfparam name="AppSettings.HTML.PageColor" type="string" default="white">
<cfparam name="AppSettings.HTML.FontFace" type="string" default="sans-serif">
<cfparam name="AppSettings.TimeZone.Code" type="string" default="EST">


<html>
<head>
 <title>Application Settings</title>
</head>

<body>
<h2>Application Settings</h2>


<!--- Simple form to gather application settings --->
<cfform action="#CGI.SCRIPT_NAME#" 
        method="POST">
  
  <!--- Hidden field for detecting when the form is being submitted --->
  <cfinput type="Hidden" 
           name="IsSavingSettings"
           value="Yes">
  
  <!--- Text field for company name --->
  <p>Company Name:<br>
  <cfinput name="CompanyName" 
           value="#AppSettings.CompanyName#"
           size="40"
           required="Yes" 
           message="Please do not leave the company name blank.">
  
  <!--- Text field for application title --->
  <p>Application Title:<br>
  <cfinput name="AppTitle" 
           value="#AppSettings.AppTitle#"
           size="40"
           required="Yes" 
           message="Please do not leave the application title blank.">

  <!--- Text field for page color --->  
  <p>Page Color:<br>
  <CFinput name="PageColor" 
           value="#AppSettings.HTML.PageColor#"
           size="15"
           required="Yes" 
           message="Please do not leave the page color blank.">
    
  <!--- Radio buttons for font face --->  
  <p>Main Font Face:<br>  
  <cfif AppSettings.HTML.FontFace EQ "sans-serif">
   <cfset checked="yes">
  <cfelse>
   <cfset checked="no">
  </cfif>
  <cfinput type="Radio"
           name="FontFace"
           value="sans-serif"
		   checked="#checked#"> 
  <font face="sans-serif">sans-serif</font>
  <cfif AppSettings.HTML.FontFace EQ "serif">
   <cfset checked="yes">
  <cfelse>
   <cfset checked="no">
  </cfif>
  <cfinput type="Radio"
           name="FontFace"
           value="serif"
           checked="#checked#">
  <font face="serif">serif</font> 

  <p>Time Zone:<br>
  <cfselect name="TimeZoneCode"
            selected="#AppSettings.TimeZone.Code#"
            query="TimeZones"
            value="Code"
            display="Description"/>  
    
  <!--- Submit button to save settings --->  
  <p>
  <cfinput type="Submit"
           name="submit" 
           value="Save Settings Now"><br>

  <!--- Display when the settings were last edited, if available --->  
  <cfif IsDefined("AppSettings.SettingsLastEdited")>
    <cfoutput>
      <font size="1">
        (Settings last edited on #DateFormat(AppSettings.SettingsLastEdited)#
        at #TimeFormat(AppSettings.SettingsLastEdited)#)
      </font>
    </cfoutput>
  </cfif>

</cfform>

</body>
</html>
